<?php

// Koneksi ke database
require 'koneksi.php';
require 'header1.php';

$sesi = $_SESSION['level'];
if ($sesi == "") {
    header("location: login.php");
}


// Jika tombol submit ditekan, tambahkan data ke database
if (isset($_POST["submit"])) {
    $alternatif = $_POST["alternatif"];
    $nama = $_POST["nama"];
    $nim = $_POST["nim"];
    $email = $_POST["email"];

    // Masukkan data ke tabel mahasiswa
    $query = "INSERT INTO mahasiswa (alternatif, nama, nim, email) VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ssss", $alternatif, $nama, $nim, $email);

    if ($stmt->execute()) {
    
        echo "
        <script>
            alert('Data berhasil ditambahkan!');
            window.location = 'tambah_mahasiswa.php';
        </script>";
    } else {
        echo "
        <script>
            alert('Data gagal ditambahkan!');
        </script>";
    }
}

// Jika tombol hapus ditekan
if (isset($_GET['hapus'])) {
    $id = $_GET['hapus'];

    // Ambil alternatif sebelum menghapus mahasiswa
    $query_get_alternatif = "SELECT alternatif FROM mahasiswa WHERE id = ?";
    $stmt_get = $conn->prepare($query_get_alternatif);
    $stmt_get->bind_param("i", $id);
    $stmt_get->execute();
    $stmt_get->bind_result($alternatif);
    $stmt_get->fetch();
    $stmt_get->close();

    // Hapus dari tabel mahasiswa
    $query = "DELETE FROM mahasiswa WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        // Hapus juga dari tabel input_nilai1 berdasarkan alternatif yang sama
        $query_hapus_nilai = "DELETE FROM input_nilai1 WHERE alternatif = ?";
        $stmt_hapus_nilai = $conn->prepare($query_hapus_nilai);
        $stmt_hapus_nilai->bind_param("s", $alternatif);
        $stmt_hapus_nilai->execute();

        echo "
        <script>
            alert('Data berhasil dihapus!');
            window.location = 'tambah_mahasiswa.php';
        </script>";
    } else {
        echo "
        <script>
            alert('Gagal menghapus data!');
        </script>";
    }
}
?>


<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid py-4">

            <h2 class="mb-4 text-center">Form Tambah Data Mahasiswa</h2>
        </div>
            <!-- Form Tambah Mahasiswa -->
            <form action="" method="post">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label text-center">Alternatif</label>
                        <input type="text" name="alternatif" class="form-control form-control-lg" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label text-center">Nama</label>
                        <input type="text" name="nama" class="form-control form-control-lg" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label text-center">NIM</label>
                        <input type="text" name="nim" class="form-control form-control-lg" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label text-center">Email</label>
                        <input type="email" name="email" class="form-control form-control-lg" required>
                    </div>
                </div>
                <div class="text-center">
                    <button class="btn btn-primary btn-lg px-4 py-2" type="submit" name="submit">
                    <i class="fas fa-plus"></i> Tambah Data
                    </button>
                </div>
            </form>
            <br><br>
 
<br><br>
            <!-- Tabel Daftar Mahasiswa -->
            <h3 class="mb-3 text-center">Daftar Mahasiswa</h3>
            <div class="table-responsive">
                <table class="table table-bordered table-sm align-middle text-center">
                    <thead class="table-primary">
                        <tr style="height: 40px;">
                            <th>No</th>
                            <th>Alternatif</th>
                            <th>Nama Mahasiswa</th>
                            <th>NIM</th>
                            <th>E-mail</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $result = mysqli_query($conn, "SELECT * FROM mahasiswa ORDER BY id DESC");
                        $no = 1;
                        while ($row = mysqli_fetch_assoc($result)) :
                        ?>
                            <tr style="height: 35px;">
                                <td><?= $no++; ?></td>
                                <td><?= htmlspecialchars($row['alternatif']); ?></td>
                                <td><?= htmlspecialchars($row['nama']); ?></td>
                                <td><?= htmlspecialchars($row['nim']); ?></td>
                                <td><?= htmlspecialchars($row['email']); ?></td>
                                <td>
                                    <a href="ubah_mahasiswa.php?id=<?= $row['id']; ?>" class="btn btn-warning btn-sm">Edit</a>
                                    <a href="?hapus=<?= $row['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin ingin menghapus?');">Hapus</a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</div>